Scriptname zBFSPoisonRandom extends activemagiceffect  
{Script shared by Poison and Steam effects}

GlobalVariable property BFSEffectsPoison auto
GlobalVariable property BFSEffectsChanceExtra auto

Spell property BFSDeadSpell auto
Spell property BFSDeadShaderSpell auto
Spell property BFSDeadMagicSpell auto
Spell property BFSDeadMagicSpell01 auto

EffectShader property BlankShader auto
EffectShader property FXEffectShader auto
EffectShader property SkinTexture auto
EffectShader property SkinTexture2 auto

actor target
int random
int random2
float BFSPoison
float BFSChance
bool RunOnce

;;; Applies the effect randomly
EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	target = akTarget
endEvent


EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
if (BFSEffectsChanceExtra != NONE)
	BFSChance = BFSEffectsChanceExtra.GetValue()
endif

	;; Allow some time before applying the effects
	if target.IsInKillmove()
		utility.wait(3)
	else
		utility.wait(1)
	endif

	if target.IsDead() && !RunOnce
		random = Utility.RandomInt(1, 100)				;;; Determine which effect will play
		;;; Sets RunOnce to true so effects doesn't apply again
		RunOnce = true

		if random <= BFSChance
			;;; == Poison ===
			if !target.HasSpell(BFSDeadShaderSpell) && !target.HasSpell(BFSDeadMagicSpell) && SkinTexture != NONE		;; Don't allow this effect to overwrite other BFSEffects
				BlankShader.play(target)	;;; This will remove any shader to allow the skin shader to be applied without problems
					if (BFSEffectsPoison != NONE)
						BFSPoison = BFSEffectsPoison.GetValue()
					endif
				;;utility.wait(1)	;; allow some time before applying shaders, it won't work if killmoved due to duration of killmove 
				if BFSPoison == 1
					SkinTexture.play(target)
				elseif BFSPoison == 2
					SkinTexture2.play(target)
				endif
				;target.AddSpell(BFSDeadShaderSpell, false)		;; Allow other BFS effects to overwrite the skin shader
				target.AddSpell(BFSDeadMagicSpell, false)		;; Prevent the skin shader from being applied again
			endif
			;;; === Steam ===
			if BFSDeadMagicSpell01 != NONE && !target.HasSpell(BFSDeadMagicSpell01)
				random2 = Utility.RandomInt(15, 25)
				FXEffectShader.play(target, random2)
				target.AddSpell(BFSDeadMagicSpell01, false)
			endif
			target.AddSpell(BFSDeadSpell, false)
		endif
	endif

endEvent
